# File : "mfEngine.tcl"
#                        Created : 2001-02-06 22:07:36
#              Last modification : 2001-02-13 23:59:23
# Author : Bernard Desgraupes
# e-mail : <berdesg@easynet.fr>
# www : <http://perso.easynet.fr/~berdesg/>
# Description : this file is part of the Metafont Mode package for 
# Alpha. See comments at the beginning of 'mfMode.tcl'.
# 


namespace eval Mf {}


# Procs to process the Metafont source files
# ==========================================

proc Mf::runbufferProc {} {
    global mf_params MfmodeVars 	
    if {[string length $MfmodeVars(mfAppSig)]} {
	app::launchFore "$MfmodeVars(mfAppSig)"
	switch $MfmodeVars(mfAppSig) {
	    "CMT3" { 	
		Mf::buildCMTcmdLine
		Mf::doMfscript
	    }
	    "OzMF" {
		if {$mf_params(chosenMode) == "proof"} {
		    Mf::doMfscript
		} else {
		    set mf_params(resol) "[Mf::findmoderes]"
		    Mf::buildOZmakeLine
		    Mf::createmakefile
		    Mf::runmakefile
		}
	    }
	}
	set mf_params(done) 1
	if {$mf_params(chosenMode) != "proof" && $mf_params(chosenMode) != "smoke"} {
	    set mf_params(tfmdone) 1
	}
	Mf::rebuildSubmenus ""
    } else {
	alertnote "No Mf app. selected. Select it in the Current mode preferences."
    }
}

proc Mf::doMfscript {} {
    global mf_params MfmodeVars 
    switch $MfmodeVars(mfAppSig) {
	"CMT3" {
	    set name [file join $mf_params(outputfolder) ""]
	    eval "AEBuild 'CMT3'" CMTX exec {----} [list $mf_params(cmdline)] dest [tclAE::build::alis $name]
	}
	"OzMF" {
	    app::launchFore "OzMF"
	    AEBuild 'OzMF' aevt odoc ---- [tclAE::build::alis $mf_params(fullfilename)]
	}
    }
}

proc Mf::runafolderProc {} {
    global mf_params
    catch {get_directory -p "Select a folder."} mf_params(folderpath)
    if {$mf_params(folderpath) == ""} { return }
    set mf_params(currentdir) $mf_params(folderpath)
    Mf::runFolder
}	

proc Mf::runcurrfoldProc {} {
    global mf_params 
    if {$mf_params(currentdir) == ""}  {
	alertnote "No folder currently selected"
	return
    }
    set mf_params(folderpath) $mf_params(currentdir)
    Mf::runFolder
}	

proc Mf::runFolder {} {
    global mf_params MfmodeVars 
    set mf_params(prefixrmall) ""
    set mf_params(filesindir) [glob -nocomplain -dir [file join $mf_params(folderpath)] *.mf]
    if {[llength $mf_params(filesindir)] == 0} {
	alertnote "No \".mf\" files in this folder."
	return
    } 
    if {[string length $MfmodeVars(mfAppSig)]} {
	Mf::domaketexpk
	menu::buildSome otherFiles
    } else {
	alertnote "No Mf app. selected. Select it in the Current mode preferences."
    }					
}

proc Mf::domaketexpk {} {
    global mf_params 
    if {[file exists [file join $mf_params(folderpath) tmpall.make]]} {
	file delete [file join $mf_params(folderpath) tmpall.make]
    }
    switch [buttonAlert "OK to process all \".mf\" files from $mf_params(folderpath) ?" "yes" "cancel" ] {
	"yes" {
	    set fileId [open [file join $mf_params(folderpath) tmpall.make] a+] 
	    set mf_params(resol)  "[Mf::findmoderes]"
	    message "$mf_params(resol)"
	    foreach file $mf_params(filesindir) {
		# We open each file because in the case when no mf file is open
		# we get problems with unrecognized MfmodeVars values
		edit -w $file
		set mf_params(fullfilename) $file
		set mf_params(tailfilename) [file tail $file]
		Mf::buildOZmakeLine
		puts $fileId $mf_params(cmdline)
	    }
	    close $fileId
	    Mf::runmakeallfile
	}
	"cancel" {
	    app::launchFore "ALFA"
	    return 
	}
    }
}

proc Mf::checkdirty {} {
    if {[winDirty]} {
	case [askyesno -c "Dirty window '[lindex [winNames] 0]'. Do you want to save it ?"] in {
	    "yes" {save}
	    "no" {}
	    "cancel" {return 0}
	}
    }
    return 1
}


# Scripts and Command Lines
# =========================

proc Mf::buildCMTcmdLine {} {
    global mf_params MfmodeVars 
    set mf_params(cmdline) "mf "
    #    choosing the mode
    if {$mf_params(chosenMode) != "proof"} {
	if {$mf_params(chosenMode) == "smoke" || $mf_params(chosenMode) == "localfont"} {
	    append mf_params(cmdline) "\\mode=$mf_params(chosenMode); "
	} else {
	    append mf_params(cmdline) "\\mode=$MfmodeVars(mfModeForPrinter);"
	}
    } else {
	append mf_params(cmdline) "\\ "
    }
    #   Do we magnify ?
    if {$mf_params(magflag) == 1} {
	append mf_params(cmdline) "mag=$mf_params(mag); "
    } elseif {$mf_params(magstepflag) == 1} {
	append mf_params(cmdline) "mag=magstep\($mf_params(magstep)\); "
    }
    #    Add the (optional!) options if the corresponding flag is set
    if {$mf_params(screenchars)} {append mf_params(cmdline) "screenchars; "}
    if {$mf_params(screenstrokes)} {
	if {$mf_params(chosenMode) != "proof"} {
	    alertnote "The \"screenstrokes\" option is for proof mode only. I'll ignore it."
	    Mf::Toggle screenstrokes
	    Mf::shadowMode screenstrokes
	} else {
	    append mf_params(cmdline) "screenstrokes; "
	}
    }
    if {$mf_params(imagerules)} {
	append mf_params(cmdline) "imagerules; "
    }
    if {$mf_params(gfcorners)} {
	append mf_params(cmdline) "gfcorners; "
    }
    if {$mf_params(nodisplays)} {
	if {$mf_params(chosenMode) != "proof"} {
	    alertnote "The \"nodisplays\" option is for proof mode only. I'll ignore it."
	} elseif {$mf_params(screenchars) || $mf_params(screenstrokes)} {
	    beep 
	    alertnote "Contradictory options : you can't use \"nodisplays\" with \"screenchars\" or \"screenstrokes\". I'll ignore it."
	    Mf::Toggle nodisplays
	    Mf::shadowMode nodisplays
	} else {
	    append mf_params(cmdline) "nodisplays; "
	}
    }
    if {$mf_params(notransforms)} {
	append mf_params(cmdline) "notransforms; "
    }
    #    Input a base file if any
    if {$mf_params(basefileflag) == 1} {
	append mf_params(cmdline) "input $mf_params(basefile);"
    }
    append mf_params(cmdline) "input $mf_params(tailfilename);"
    #   Now the file to process.
    set mf_params(cmdline) [curlyq $mf_params(cmdline)]
}

# OzMetafont cannot receive a complete command line through an Apple Event. 
# The workaround is to create a ".make" file which OzMetafont will process 
# with its built-in MakeTeXPK.
#	 	(Good) side effect : the "pk" files will be done in the same time,
#	 	thus no need to invoke gftopk after that.
proc Mf::buildOZmakeLine {} {
    global mf_params MfmodeVars 
    set mf_params(cmdline) "MakeTeXPK [file rootname $mf_params(tailfilename)] "
    # What is the resolution corresponding to the printer mode ? We look for it in the
    # modes.mf file.
    append mf_params(cmdline) "[lindex $mf_params(resol) 1] [lindex $mf_params(resol) 1] "
    #   Do we magnify ?
    if {$mf_params(magflag) == 1} {
	append mf_params(cmdline) "$mf_params(mag) "
    } elseif {$mf_params(magstepflag) == 1} {
	append mf_params(cmdline) "magstep\($mf_params(magstep)\) "
    } else {
	append mf_params(cmdline) "1 "
    }
    #   Choose the mode
    if {$mf_params(chosenMode) == "localfont"} {
	append mf_params(cmdline) 	"[lindex $mf_params(resol) 0]"	
    } elseif {$mf_params(chosenMode) == "proof" || $mf_params(chosenMode) == "smoke"} {
	append mf_params(cmdline) "$mf_params(chosenMode)"
    } else {
	append mf_params(cmdline) $MfmodeVars(mfModeForPrinter)
    }
    #    Add the (optional!) options if the corresponding flag is set
    if {$mf_params(screenchars)} {append mf_params(cmdline) ";screenchars"}
    if {$mf_params(screenstrokes)} {
	if {$mf_params(chosenMode) != "proof"} {
	    alertnote "The \"screenstrokes\" option is for proof mode only. I'll ignore it."
	    Mf::Toggle screenstrokes
	    Mf::shadowMode screenstrokes
	} else {
	    append mf_params(cmdline) ";screenstrokes"
	}
    }
    if {$mf_params(imagerules)} {
	append mf_params(cmdline) ";imagerules"
    }
    if {$mf_params(gfcorners)} {
	append mf_params(cmdline) ";gfcorners"
    }
    if {$mf_params(nodisplays)} {
	if {$mf_params(chosenMode) != "proof"} {
	    alertnote "The \"nodisplays\" option is for proof mode only. I'll ignore it."
	} elseif {$mf_params(screenchars) || $mf_params(screenstrokes)} {
	    beep 
	    alertnote "Contradictory options : you can't use \"nodisplays\" with \"screenchars\" or \"screenstrokes\". I'll ignore it."
	    Mf::Toggle nodisplays
	    Mf::shadowMode nodisplays
	} else {
	    append mf_params(cmdline) ";nodisplays"
	}
    }
    if {$mf_params(notransforms)} {
	append mf_params(cmdline) ";notransforms"
    }
    #   Input a base file if any
    if {$mf_params(basefileflag) == 1} {
	append mf_params(cmdline) ";input $mf_params(basefile)"
    }
}


# Makefiles
# ---------

proc Mf::createmakefile {} {
    global mf_params
    set fileId [open "[file dirname $mf_params(fullfilename)]:tmp.make" w+] 
    puts $fileId $mf_params(cmdline)
    close $fileId
}

proc Mf::runmakefile {} {
    global mf_params
    app::launchFore "OzMF"
    set filename [file join $mf_params(dirfilename) tmp.make]
    AEBuild 'OzMF' aevt odoc ---- [tclAE::build::alis $filename]
}

proc Mf::runmakeallfile {} {
    global mf_params MfmodeVars
    switch $MfmodeVars(mfAppSig) {
	"CMT3" {
	    app::launchFore "CMT9"
	    set filename [file join $mf_params(folderpath) tmpall.make]
	    AEBuild 'CMT9' aevt odoc ---- [tclAE::build::alis $filename]
	}
	"OzMF" {
	    app::launchFore "OzMF"
	    set filename [file join $mf_params(folderpath) tmpall.make]
	    AEBuild  'OzMF' aevt odoc ---- [tclAE::build::alis $filename]
	}
    }
}

